/*
 * @(#)PertMenuBuilder.java  1.0  2011-02-21
 * 
 * Copyright (c) 2011 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied
 * Sciences and Arts (HSLU). You may not use, copy or modify this software,
 * except in accordance with the license agreement you entered into with HSLU.
 * For details see accompanying license terms.
 */
package ch.hslu.cm.pert;

import ch.hslu.cm.cer.*;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.DefaultMenuBuilder;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.ActionUtil;
import org.jhotdraw.util.ResourceBundleUtil;

/**
 * {@code PertMenuBuilder}.
 *
 * @author Werner Randelshofer
 * @version 1.0 2011-01-14 Created.
 */
public class PertMenuBuilder extends DefaultMenuBuilder {

    @Override
    public void addOtherViewItems(JMenu m, Application app, View v) {
        m.addSeparator();
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");

        JCheckBoxMenuItem cbmi;
        JMenu m2;
        ActionMap am = app.getActionMap(v);
        cbmi = new JCheckBoxMenuItem(am.get("toggleOptionsPanel"));
        ActionUtil.configureJCheckBoxMenuItem(cbmi, am.get("toggleOptionsPanel"));
        m.add(cbmi);
        m.addSeparator();
        cbmi = new JCheckBoxMenuItem(am.get("toggleGrid"));
        ActionUtil.configureJCheckBoxMenuItem(cbmi, am.get("toggleGrid"));
        m.add(cbmi);
        m2 = new JMenu("Zoom");
        for (double sf : PertApplicationModel.scaleFactors) {
            String id = (int) (sf * 100) + "%";
            cbmi = new JCheckBoxMenuItem(am.get(id));
            ActionUtil.configureJCheckBoxMenuItem(cbmi, am.get(id));
            m2.add(cbmi);
        }
        m.add(m2);
        m.addSeparator();
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rbmi;
        group.add(m.add(rbmi = new JRadioButtonMenuItem(am.get("pArrangeVertical"))));
        ActionUtil.configureJCheckBoxMenuItem(cbmi, am.get("pArrangeVertical"));
        group.add(m.add(rbmi = new JRadioButtonMenuItem(am.get("pArrangeHorizontal"))));
        ActionUtil.configureJCheckBoxMenuItem(cbmi, am.get("pArrangeHorizontal"));
        group.add(m.add(rbmi = new JRadioButtonMenuItem(am.get("pArrangeCascade"))));
        ActionUtil.configureJCheckBoxMenuItem(cbmi, am.get("pArrangeCascade"));


    }

    @Override
    public void addOtherMenus(List<JMenu> mb, Application app, View v) {
        ResourceBundleUtil appLabels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        ResourceBundleUtil cerLabels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels");
        ResourceBundleUtil cmLabels = ResourceBundleUtil.getBundle("ch.hslu.cm.Labels");
        ActionMap am = app.getActionMap(v);
        JMenu m;
        m = new JMenu();
        cmLabels.configureMenu(m, "extras");
        m.add(am.get(ComparePertModelsAction.ID));
        mb.add(m);

    }
}
